% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRNAHybrids.R
\name{getRNAHybrids}
\alias{getRNAHybrids}
\title{Run prediciton of RNA hybridization}
\usage{
getRNAHybrids(gi, fafile)
}
\arguments{
\item{gi}{\code{Ginteraction} with pairs of regions}

\item{fafile}{path to the .fasta file with genome}
}
\value{
object parallel to input with added energy GC content,
dot-format base-pairings and lenghts of RNA hybrids
will return the input, if RNAhybrids cannot be run
}
\description{
Calls RNAduplex from ViennaRNA to find base-pairs for every entry in the
input, throws a message and system warning if it is not installed
}
\examples{
sequence <- paste0(
    "AGCUAGCGAUAGCUAGCAUCGUAGCAUCGAUCGUAAGCUAGCUAGCUAGCAUCGAUCGUAGCUAGCAUCGAU",
    "CGUAGCAUCGUAGCUAGCUAGCUAUGCGAUU"
)

# Save the sequence to a temp fasta file
fasta_file <- tempfile(fileext = ".fa")
chrom <- "test_chrA"
writeLines(c(">test_chrA", sequence), con = fasta_file)

# Create the GInteraction object
# Define start and end positions for the base-pairing regions
regions <- data.frame(
    start1 = c(1, 11, 21, 31, 41),
    end1 = c(10, 20, 30, 40, 50),
    start2 = c(91, 81, 71, 61, 51),
    end2 = c(100, 90, 80, 70, 60)
)
# GRanges objects for the anchors
anchor1 <- GRanges(seqnames = chrom, ranges = IRanges(start = regions$start1, end = regions$end1))
anchor2 <- GRanges(seqnames = chrom, ranges = IRanges(start = regions$start2, end = regions$end2))
interaction <- GInteractions(anchor1, anchor2)
# predict hybrids
# In case ViennaRNA is installed
\dontrun{
gi_with_hybrids <- getRNAHybrids(interaction, fasta_file)
}
}
