% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IdentifyMCB.R
\name{IdentifyMCB}
\alias{IdentifyMCB}
\title{Identification of methylation correlated blocks}
\usage{
IdentifyMCB(
  MethylationProfile,
  method = c("pearson", "spearman", "kendall")[1],
  CorrelationThreshold = 0.8,
  PositionGap = 1000,
  platform = "Illumina Methylation 450K",
  verbose = T
)
}
\arguments{
\item{MethylationProfile}{Methylation matrix is used in the analysis.}

\item{method}{method used for calculation of correlation, \cr
should be one of "pearson","spearman","kendall". Defualt is "pearson".}

\item{CorrelationThreshold}{coef correlation threshold is used for define boundaries.}

\item{PositionGap}{CpG Gap between any two CpGs positioned CpG sites less than 1000 bp (default) will be calculated.}

\item{platform}{This parameter indicates the platform used to produce the methlyation profile. 
You can use your own annotation file.}

\item{verbose}{True as default, which will print the block information for each chromosome.}
}
\value{
Object of class \code{list} with elements:
 \tabular{ll}{
   \code{MCBsites} \tab Character set contains all CpG sites in MCBs. \cr
   \code{MCBinformation} \tab Matrix contains the information of results. \cr
 }
}
\description{
This function is used to partition the genome into blocks of tightly co-methylated CpG sites, \cr
Methylation correlated blocks. This function calculates Pearson correlation coefficients between \cr
the beta values of any two CpGs < CorrelationThreshold was used to identify boundaries between any two \cr
adjacent markers indicating uncorrelated methylation. Markers not separated by a boundary were combined into MCB. Pearson correlation coefficients between \cr
two adjacent CpGs were calculated.
}
\details{
Currently, only illumina 450k platform is supported, the methylation profile need to convert into matrix format.
}
\examples{
data('demo_data',package = "EnMCB")

#import the demo TCGA data with 10000+ CpGs site and 455 samples
#remove # to run
res<-IdentifyMCB(demo_data$realdata)
demo_MCBinformation<-res$MCBinformation


}
\references{
Xin Yu, De-Xin Kong, EnMCB: an R/bioconductor package for predicting disease progression based on methylation correlated blocks using ensemble models, Bioinformatics, 2021, btab415
}
\author{
Xin Yu
}
