% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpplapply.R
\name{bpplapply}
\alias{bpplapply}
\title{Wrapper for \link[BiocParallel]{bplapply}}
\usage{
bpplapply(
  X,
  FUN,
  apply_fun = parallel::mclapply,
  workers = check_workers(),
  progressbar = workers > 1,
  verbose = workers == 1,
  use_snowparam = TRUE,
  register_now = FALSE,
  ...
)
}
\arguments{
\item{X}{
    Any object for which methods \code{length}, \code{[}, and
    \code{[[} are implemented.
  }

\item{FUN}{
    The \code{function} to be applied to each element of \code{X}.
  }

\item{apply_fun}{Iterator function to use.}

\item{workers}{Number of threads to parallelize across.}

\item{progressbar}{
    \code{logical(1)} Enable progress bar (based on plyr:::progress_text).
  }

\item{verbose}{Print messages.}

\item{use_snowparam}{Whether to use
\link[BiocParallel]{SnowParam} (default: \code{TRUE}) or
\link[BiocParallel]{MulticoreParam} (\code{FALSE})
 when parallelising across multiple \code{workers}.}

\item{register_now}{Register the cores now with
\link[BiocParallel]{register} (\code{TRUE}),
 or simply return the \code{BPPARAM object} (default: \code{FALSE}).}

\item{...}{
  Arguments passed on to \code{\link[BiocParallel:bplapply]{BiocParallel::bplapply}}
  \describe{
    \item{\code{BPPARAM}}{
    An optional \code{\link[BiocParallel]{BiocParallelParam}} instance
    determining the parallel back-end to be used during evaluation, or a
    \code{list} of \code{BiocParallelParam} instances, to be applied in
    sequence for nested calls to \pkg{BiocParallel} functions.
  }
    \item{\code{BPREDO}}{A \code{list} of output from \code{bplapply} with one or
    more failed elements. When a list is given in \code{BPREDO},
    \code{bpok} is used to identify errors, tasks are rerun and inserted
    into the original results.
  }
    \item{\code{BPOPTIONS}}{
    Additional options to control the behavior of the parallel evaluation, see \code{\link[BiocParallel]{bpoptions}}.
  }
  }}
}
\value{
(Named) list.
}
\description{
Wrapper function for \link[BiocParallel]{bplapply} that automatically
handles issues with \pkg{BiocParallel} related to different OS platforms.
}
\examples{
X <- stats::setNames(seq_len(length(letters)), letters)
out <- bpplapply(X, print) 
}
