% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CpGClustering.R
\name{ClusterProbes}
\alias{ClusterProbes}
\title{The ClusterProbes function}
\usage{
ClusterProbes(MET_data, ProbeAnnotation, CorThreshold = 0.4)
}
\arguments{
\item{MET_data}{data matrix for methylation.}

\item{ProbeAnnotation}{GRange object for probe annoation.}

\item{CorThreshold}{correlation threshold for cutting the clusters.}
}
\value{
List with the clustered data sets and the mapping between probes and genes.
}
\description{
This function uses the annotation for Illumina methylation arrays to map each probe to a gene. Then, for each gene,
it clusters all its CpG sites using hierchical clustering and Pearson correlation as distance and complete linkage.
If data for normal samples is provided, only overlapping probes between cancer and normal samples are used.
Probes with SNPs are removed.
This function is prepared to run in parallel if the user registers a parallel structure, otherwise it runs sequentially.
This function also cleans up the sample names, converting them to the 12 digit format.
}
\keyword{cluter_probes}
