% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventDetectionMultipath.R
\name{EventDetectionMultipath}
\alias{EventDetectionMultipath}
\title{Detect splicing multipath events using EventPointer methodology}
\usage{
EventDetectionMultipath(Input, cores, Path, paths = 2)
}
\arguments{
\item{Input}{Output of the PrepareBam_EP function.}

\item{cores}{Number of cores used for parallel processing.}

\item{Path}{Directory where to write the EventsFound_RNASeq.txt file.}

\item{paths}{Maximum number of paths of the events to find.}
}
\value{
List with all the events found for all the genes present in the experiment and a file called EventsFound_RNASeq.txt with the information each event.
}
\description{
Identification of all the multipath alternative splicing events in the splicing graphs.
}
\examples{
\dontrun{
  # Run EventDetection function
   data(SG_RNASeq)
   TxtPath<-tempdir()
   AllEvents_RNASeq_MP<-EventDetectionMultipath(SG_RNASeq,cores=1,Path=TxtPath,paths=3)
   }

}
