% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Short_CV.R
\name{Select_Model_short_SC3}
\alias{Select_Model_short_SC3}
\title{Using clustering results based on feature selection to perform model selection.}
\usage{
Select_Model_short_SC3(Y, cluster, tops = c(500, 1000, 2000))
}
\arguments{
\item{Y}{A gene expression matrix}

\item{cluster}{The initial cluster labels NA values are allowed. This can directly from the \code{Consensus} function.}

\item{tops}{A numeric vector containing a list of numbers corresponding to top genes; e.g., tops = c(500, 1000, 2000).}
}
\value{
mse and the SC3 clustering result.
}
\description{
Using clustering results based on feature selection to perform model selection.
}
\examples{
data(Yan)
k = length(unique(trueclass))
Y = process_Y(Y, thre = 2) # preprocess the data
set.seed(123)
rixs = sample(nrow(Y), 500)
cixs = sample(ncol(Y), 40)
Y = Y[rixs, cixs]
con_res = Consensus(Y, k=k)
# not run
# mod_res = Select_Model_short_SC3(Y, cluster = con_res$cluster, top = c(100, 200))
}
