% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{plot_spatial_feature}
\alias{plot_spatial_feature}
\title{Plot feature on spatial image}
\usage{
plot_spatial_feature(
  spe,
  feature,
  opacity = 50,
  grayscale = TRUE,
  size = 1,
  assay_type = "counts",
  color = "red",
  ...
)
}
\arguments{
\item{spe}{The SpatialExperiment object.}

\item{feature}{The feature to plot. Could be either a feature name or index 
present in the assay or a numeric vector of length nrow(spe).}

\item{opacity}{The opacity of the background tissue image.}

\item{grayscale}{Whether to convert the background image to grayscale.}

\item{size}{The size of the points.}

\item{assay_type}{The assay that contains the given features. E.g. 'counts', 'logcounts'.}

\item{color}{The maximum color for the feature. Minimum color is transparent.}

\item{...}{Additional arguments to pass to \code{\link[ggplot2]{geom_point}}.}
}
\value{
A ggplot object.
}
\description{
This function plots a spatial point plot for given feature
}
