% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_buildSOM.R
\name{GetPercentages}
\alias{GetPercentages}
\title{GetPercentages}
\usage{
GetPercentages(fsom, level = "metaclusters")
}
\arguments{
\item{fsom}{FlowSOM object}

\item{level}{Character string, should be either "clusters" or 
"metaclusters" (default) or abbreviations.}
}
\value{
A named vector with the percentages
}
\description{
Get percentages of number of cells in clusters or metaclusters
}
\examples{
# Read from file, build self-organizing map and minimal spanning tree
fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
ff <- flowCore::read.FCS(fileName)
ff <- flowCore::compensate(ff, flowCore::keyword(ff)[["SPILL"]])
ff <- flowCore::transform(ff, flowCore::estimateLogicle(ff,
                                               flowCore::colnames(ff)[8:18]))
flowSOM.res <- FlowSOM(ff,
                       scale = TRUE,
                       colsToUse = c(9, 12, 14:18),
                       nClus = 10,
                       seed = 1)
GetPercentages(flowSOM.res)                      
GetPercentages(flowSOM.res, level = "clusters")
}
