% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_plotFunctions.R
\name{PlotStars}
\alias{PlotStars}
\title{PlotStars}
\usage{
PlotStars(
  fsom,
  markers = fsom$map$colsUsed,
  colorPalette = FlowSOM_colors,
  list_insteadof_ggarrange = FALSE,
  ...
)
}
\arguments{
\item{fsom}{FlowSOM object, as generated by \code{\link{BuildMST}}}

\item{markers}{Markers to plot (will be parsed by GetChannels)}

\item{colorPalette}{Color palette to use}

\item{list_insteadof_ggarrange}{If FALSE (default), the plot and the legend
are combined by ggarrange. If TRUE, the
separate elements are returned in a list,
to allow further customization.}

\item{...}{Additional arguments to pass to \code{\link{PlotFlowSOM}}}
}
\value{
Nothing is returned. A plot is drawn in which each node is 
represented by a star chart indicating the median fluorescence intensities.
Resets the layout back to 1 plot at the end.
}
\description{
Plot star charts
}
\details{
Plot FlowSOM grid or tree, where each node is represented by 
a star chart indicating median marker values
}
\examples{
# Read from file, build self-organizing map and minimal spanning tree
fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
flowSOM.res <- FlowSOM(fileName, compensate = TRUE, transform = TRUE,
                       scale = TRUE, colsToUse = c(9, 12, 14:18))

# Plot stars indicating the MFI of the cells present in the nodes
PlotStars(flowSOM.res, backgroundValues = flowSOM.res$metaclustering)

newLayout <- igraph::layout_with_fr(flowSOM.res[["MST"]][["graph"]])
PlotStars(flowSOM.res, backgroundValues = flowSOM.res$metaclustering, 
          view = newLayout)
          
PlotStars(flowSOM.res, backgroundValues = flowSOM.res$metaclustering, 
          view = "grid")

}
\seealso{
\code{\link{PlotMarker}}, \code{\link{PlotVariable}},
\code{\link{PlotFlowSOM}}, \code{\link{PlotLabels}}, 
\code{\link{PlotNumbers}}, \code{\link{PlotPies}}, 
\code{\link{QueryStarPlot}}, \code{\link{PlotSD}}
}
