% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_plotFunctions.R
\name{QueryStarPlot}
\alias{QueryStarPlot}
\title{QueryStarPlot}
\usage{
QueryStarPlot(
  fsom,
  query,
  plot = TRUE,
  colorPalette = FlowSOM_colors,
  backgroundColors = "#CA0020",
  ...
)
}
\arguments{
\item{fsom}{FlowSOM object, as generated by \code{\link{BuildMST}}}

\item{query}{Array containing "high" or "low" (or abbreviations)
for the specified column names of the FlowSOM data.}

\item{plot}{If true, a plot with a gradient of scores for the 
nodes is shown.}

\item{colorPalette}{Color palette to be used for colors for "stars", 
"pies" or "marker". Can be either a function or an 
array specifying colors.}

\item{backgroundColors}{Color to use for nodes with a high score in the plot.
Default is red.}

\item{...}{Additional arguments to pass to \code{\link{PlotFlowSOM}}}
}
\value{
A list, containing the ids of the selected nodes, the individual 
        scores for all nodes and the scores for each marker for each node
}
\description{
Query a certain cell type
}
\details{
Identify nodes in the tree which resemble a certain profile of "high"
or "low" marker expressions.
}
\examples{
   file <- system.file("extdata", "68983.fcs", package="FlowSOM")
   flowSOM.res <- FlowSOM(file, compensate = TRUE, transform = TRUE, 
                  scale = TRUE, colsToUse = c(9, 12, 14:18), nClus = 10, 
                  silent = FALSE, xdim = 7, ydim = 7)
   query <- c("CD3" = "high", #CD3
              "CD4" = "low", #TCRb
              "CD8" = "high") #CD8
   query_res <- QueryStarPlot(flowSOM.res, query, equalNodeSize = TRUE)
   
   cellTypes <- factor(rep("Unlabeled", 49), 
                       levels = c("Unlabeled", "CD8 T cells"))
   cellTypes[query_res$selected] <- "CD8 T cells"
   PlotStars(flowSOM.res,
             backgroundValues = cellTypes,
             backgroundColors = c("#FFFFFF00", "#ca0020aa"))
   
}
\seealso{
\code{\link{PlotStars}}, \code{\link{PlotVariable}},
\code{\link{PlotFlowSOM}}, \code{\link{PlotLabels}}, 
\code{\link{PlotNumbers}}, \code{\link{PlotMarker}}, 
\code{\link{PlotPies}}, \code{\link{PlotSD}}
}
