% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_buildSOM.R
\name{SOM}
\alias{SOM}
\title{Build a self-organizing map}
\usage{
SOM(
  data,
  xdim = 10,
  ydim = 10,
  rlen = 10,
  mst = 1,
  alpha = c(0.05, 0.01),
  radius = stats::quantile(nhbrdist, 0.67) * c(1, 0),
  init = FALSE,
  initf = Initialize_KWSP,
  distf = 2,
  silent = FALSE,
  map = TRUE,
  codes = NULL,
  importance = NULL
)
}
\arguments{
\item{data}{Matrix containing the training data}

\item{xdim}{Width of the grid}

\item{ydim}{Hight of the grid}

\item{rlen}{Number of times to loop over the training data for each MST}

\item{mst}{Number of times to build an MST}

\item{alpha}{Start and end learning rate}

\item{radius}{Start and end radius}

\item{init}{Initialize cluster centers in a non-random way}

\item{initf}{Use the given initialization function if init == T
(default: Initialize_KWSP)}

\item{distf}{Distance function (1 = manhattan, 2 = euclidean, 3 = chebyshev, 
4 = cosine)}

\item{silent}{If FALSE, print status updates}

\item{map}{If FALSE, data is not mapped to the SOM. Default TRUE.}

\item{codes}{Cluster centers to start with}

\item{importance}{array with numeric values. Parameters will be scaled 
according to importance}
}
\value{
A list containing all parameter settings and results
}
\description{
Build a self-organizing map
}
\references{
This code is strongly based on the \code{kohonen} package.
            R. Wehrens and L.M.C. Buydens, Self- and Super-organising Maps 
            in R: the kohonen package J. Stat. Softw., 21(5), 2007
}
\seealso{
\code{\link{BuildSOM}}
}
