
\name{ColorBar}
\alias{ColorBar}


\title{Calibration bar for color images}
\description{
This function produces a color image (color bar) which can be used for
the legend to another color image obtained from the functions
\code{\link{image}} or \code{\link{arrayPlot}}.}

\usage{
ColorBar(x, horizontal=TRUE, col=heat.colors(50), scale=1:length(x), k=10, ...)
}

\arguments{
  \item{x}{If "numeric", a vector containing the "z" values in the
    color image, i.e., the values which are represented in the color
    image. Otherwise, a "character" vector representing colors.}
  \item{horizontal}{If \code{TRUE}, the values of \code{x} are
    represented as vertical color strips in the image, else, the values
    are represented as horizontal color strips.}
  \item{col}{Vector of colors such as that generated by
    rainbow, heat.colors, topo.colors, terrain.colors, or similar
    functions. In addition to these color palette functions, a new
    function  \code{\link{myPalette}} was defined to generate color
    palettes from user supplied low, middle, and high color values.}
  \item{scale}{A "numeric" vector specifying the "z" values in the color
    image. This is used when the argument \code{x} is a
    "character" vector representing color information.}
\item{k}{Object of class "numeric", for the number of labels displayed on
    the bar.}
  \item{\dots}{Optional graphical parameters, see \code{\link{par}}.}
}


\author{Sandrine Dudoit, Yee Hwa (Jean) Yang.}

\seealso{\code{\link{image}}, \code{\link{arrayPlot}} \code{\link{myPalette}}.}

\keyword{hplot}

\examples{

par(mfrow=c(3,1))
Rcol <- myPalette(low="white", high="red", k=10)
Gcol <- myPalette(low="white", high="green", k=50)
RGcol <- myPalette(low="green", high="red", k=100)
ColorBar(Rcol)
ColorBar(Gcol, scale=c(-5,5))
ColorBar(1:50, col=RGcol)

par(mfrow=c(1,3))
x<-seq(-1, 1, by=0.01)
ColorBar(x, col=Gcol, horizontal=FALSE, k=11)
ColorBar(x, col=Gcol, horizontal=FALSE, k=21)
ColorBar(x, col=Gcol, horizontal=FALSE, k=51)

}
