% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goSim.R
\name{goSim}
\alias{goSim}
\title{Semantic similarity between two GO terms}
\usage{
goSim(GOID1, GOID2, semData, measure = "Wang")
}
\arguments{
\item{GOID1}{GO ID 1}

\item{GOID2}{GO ID 2}

\item{semData}{GOSemSimDATA object}

\item{measure}{One of "Resnik", "Lin", "Rel", "Jiang", "TCSS" and "Wang" methods.}
}
\value{
similarity
}
\description{
Given two GO IDs, calculate their semantic similarity.
}
\examples{
d <- godata('org.Hs.eg.db', ont = "MF", computeIC = FALSE)
goSim("GO:0004022", "GO:0005515", semData = d, measure = "Wang")
}
\seealso{
\code{\link[=goSim]{goSim()}} \code{\link[=mgoSim]{mgoSim()}} \code{\link[=geneSim]{geneSim()}} \code{\link[=mgeneSim]{mgeneSim()}} \code{\link[=clusterSim]{clusterSim()}} \code{\link[=mclusterSim]{mclusterSim()}}
}
\author{
Guangchuang Yu \url{https://yulab-smu.top}
}
