% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRaccessors.R
\name{GRgetMetrics}
\alias{GRgetMetrics}
\title{GR metrics}
\usage{
GRgetMetrics(fitData)
}
\arguments{
\item{fitData}{a SummarizedExperiment object, generated by the GRfit 
function.}
}
\value{
A table with GR metrics and goodness of fit measures
}
\description{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function returns a table of GR metrics (as well as traditional 
metrics) for each experiment in the dataset.
}
\details{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function returns a table of GR metrics and traditional metrics 
along with goodness of fit measures. It also identifies each fit 
as flat or sigmoidal. This is simply a convenient accessor function, 
equivalent to \code{cbind(as.data.frame(colData(fitData)), 
as.data.frame(t(assay(fitData))))}.
}
\examples{
# Load Case A (example 1) input
data("inputCaseA")
head(inputCaseA)
# Run GRfit function with case = "A"
output1 = GRfit(inputData = inputCaseA,
groupingVariables = c('cell_line','agent'))
metrics = GRgetMetrics(output1)
\dontrun{View(metrics)}
head(metrics)
}
\seealso{
To create the object needed for this function, see
\code{\link{GRfit}}.
}
\author{
Nicholas Clark
}
