% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster-classifier.R
\name{k_centroids}
\alias{k_centroids}
\title{Function to calculate the centroids of different groups (classes)}
\usage{
k_centroids(data, class)
}
\arguments{
\item{data}{a scaled gene expression \code{matrix} or \code{data.frame} 
with samples as columns and features as rows}

\item{class}{a vector with the samples classes}
}
\value{
returns a \code{data.frame} with the estimated prototypic centroids 
for each class with the features names as rownames
}
\description{
This function calculates the mean value for each feature of each class to 
calculate the prototypic centroids of the different groups
}
\examples{
# load example dataset
require(iC10TrainingData)
require(pamr)

data(train.Exp)

calculate_distance <- select_distance(distancetype = "pearson")
Dist <- calculate_distance(train.Exp)
k <- 4
Pam <- cluster_algorithm(Dist, k)
table(Pam$cluster)
centroids <- k_centroids(train.Exp, Pam)
}
