% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GINA.R
\name{GINA}
\alias{GINA}
\title{GINA for Gaussian Phenotypes}
\usage{
GINA(
  Y,
  SNPs,
  kinship,
  FDR_Nominal = 0.05,
  maxiterations = 400,
  runs_til_stop = 40
)
}
\arguments{
\item{Y}{The observed numeric phenotypes}

\item{SNPs}{The SNP matrix, where each column represents a single SNP encoded as the numeric coding 0, 1, 2. This is entered as a matrix object.}

\item{kinship}{The observed kinship matrix, has to be a square positive semidefinite matrix. Defaulted as the identity matrix. The function used
to create the kinship matrix used in the BICOSS paper is A.mat() from package rrBLUP.}

\item{FDR_Nominal}{The nominal false discovery rate for which SNPs are selected from in the screening step.}

\item{maxiterations}{The maximum iterations the genetic algorithm in the model selection step iterates for.
Defaulted at 400 which is the value used in the BICOSS paper simulation studies.}

\item{runs_til_stop}{The number of iterations at the same best model before the genetic algorithm in the model selection step converges.
Defaulted at 40 which is the value used in the BICOSS paper simulation studies.}
}
\value{
The column indices of SNPs that were in the best model identified by BICOSS.
}
\description{
Performs GINA
}
\examples{
library(GWAS.BAYES)
GINA(Y = Y, SNPs = SNPs, kinship = kinship,
    FDR_Nominal = 0.05,
    maxiterations = 400,runs_til_stop = 40)
}
