% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_PPI.R
\name{getStringDB}
\alias{getStringDB}
\title{Get the STRING db entry of a species}
\usage{
getStringDB(
  species,
  version = "12.0",
  score_threshold = 0,
  cache_location = FALSE
)
}
\arguments{
\item{species}{numeric, the NCBI ID of the species of interest}

\item{version}{character, The STRINGdb version to use, defaults to the
current version}

\item{score_threshold}{numeric, A score threshold to cut the retrieved
interactions, defaults to 0 (all interactions)}

\item{cache_location}{Logical value, defining whether to use the
BiocFileCache for retrieval of the files underlying
the \code{STRINGdb} object. Defaults to \code{TRUE}.}
}
\value{
a \code{STRINGdb} object of \code{species}
}
\description{
Get the respective \code{STRINGdb} object of your species of interest
}
\examples{
species <- getId(species = "Homo sapiens")
stringdb <- getStringDB(as.numeric(species))
}
