% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadData.R
\name{loadBSgenome}
\alias{loadBSgenome}
\title{Loads BSgenome objects from UCSC-style character vectors.}
\usage{
loadBSgenome(genomeBuild, masked = TRUE)
}
\arguments{
\item{genomeBuild}{One of 'hg19', 'hg38', 'mm10', 'mm9', or 'grch38'}

\item{masked}{Should we used the masked version? Default:TRUE}
}
\value{
A BSgenome object corresponding to the provided genome build.
}
\description{
This function will let you use a simple character vector (e.g. 'hg19') to
load and then return BSgenome objects. This lets you avoid having to use the
more complex annotation for a complete BSgenome object (e.g.
BSgenome.Hsapiens.UCSC.hg38.masked)
}
\examples{
\dontrun{
bsg = loadBSgenome('hg19')
}
}
