% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{is.pp}
\alias{is.pp}
\alias{is.pd}
\alias{is.pt}
\alias{is.dd}
\alias{is.dt}
\alias{is.tt}
\alias{isInteractionType}
\alias{is.trans}
\alias{is.cis}
\alias{InteractionHelpers}
\alias{is.pp,GInteractions-method}
\alias{is.pd,GInteractions-method}
\alias{is.pt,GInteractions-method}
\alias{is.dd,GInteractions-method}
\alias{is.dt,GInteractions-method}
\alias{is.tt,GInteractions-method}
\alias{isInteractionType,GInteractions-method}
\alias{is.trans,GInteractions-method}
\alias{is.cis,GInteractions-method}
\title{Interaction Type Helpers}
\usage{
is.pp(GIObject)

is.pd(GIObject)

is.pt(GIObject)

is.dd(GIObject)

is.dt(GIObject)

is.tt(GIObject)

isInteractionType(GIObject, x, y)

is.trans(GIObject)

is.cis(GIObject)

\S4method{is.pp}{GInteractions}(GIObject)

\S4method{is.pd}{GInteractions}(GIObject)

\S4method{is.pt}{GInteractions}(GIObject)

\S4method{is.dd}{GInteractions}(GIObject)

\S4method{is.dt}{GInteractions}(GIObject)

\S4method{is.tt}{GInteractions}(GIObject)

\S4method{isInteractionType}{GInteractions}(GIObject, x, y)

\S4method{is.trans}{GInteractions}(GIObject)

\S4method{is.cis}{GInteractions}(GIObject)
}
\arguments{
\item{GIObject}{A GInteractions object}

\item{x, y}{Names of annotated node classes}
}
\value{
A logical vector
}
\description{
Functions to classify interactions within GInteractions objects.
\itemize{
    \item 'isInteractionType' takes two character arguments which are
          annotated node classes and returns interactions between them.
    \item 'is.pp', 'is.pd' etc. are bindings for common annotations:
    \describe{ \item{p}{promoter}
               \item{d}{distal}
               \item{t}{terminator} }
    \item 'is.trans' & 'is.cis' select trans-chromosomal and
          intra-chromosomal interactions, respectively }
}
\examples{
data(hic_example_data)
table(is.cis(hic_example_data))
sum(interactionCounts(hic_example_data))

}
