% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{calcCombPValues}
\alias{calcCombPValues}
\title{Calculate p-values using the "exprs" assay}
\usage{
calcCombPValues(
  obj,
  colData_in = NULL,
  d_sd_shift = NA,
  d_abs_shift = NA,
  d_paired = FALSE,
  g_sd_shift = 0,
  use = "tz",
  p_adjust_method = "BH"
)
}
\arguments{
\item{obj}{HERONSequenceDataSet or HERONProbeDataSet}

\item{colData_in}{optional column DataFrame (default: NULL => colData(obj)))}

\item{d_sd_shift}{standard deviation shift for differential test}

\item{d_abs_shift}{absolute shift for differential test}

\item{d_paired}{run paired analysis}

\item{g_sd_shift}{standard deviation shift for global test}

\item{use}{use global-test ("z"), differential-test using t.test ("t"),
differential-test using wilcox ("w"), or both global and differential ("tz")}

\item{p_adjust_method}{method for adjusting p-values}
}
\value{
HERONSequenceDataSet/HERONProbeDataSet with the pvalue assay added
}
\description{
Calculate p-values using the "exprs" assay
}
\examples{
data(heffron2021_wuhan)
seq_pval_res <- calcCombPValues(heffron2021_wuhan)
}
