% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{hpaExport}
\alias{hpaExport}
\title{Export the subset data}
\usage{
hpaExport(data, fileName, fileType = "xlsx")
}
\arguments{
\item{data}{Input the list object generated by \code{hpaSubset()}}

\item{fileName}{A string indicate the desired output file name. Do not
include file extension such as \code{'.xlsx'}.}

\item{fileType}{The format as which the data will be exported. Choose one of
these options: \code{'xlsx'}, \code{'csv'} and \code{'tsv'}.}
}
\value{
\itemize{
  \item \code{'xlsx'}: return one .xlsx file named \code{'fileName.xlsx'}.
  One individual sheet for each dataset in the input list object.
  \item \code{'csv'}: return .csv files, one for each dataset in the input
  list object, named \code{'fileName_datasetName.csv'}
  \item \code{'tsv'}: return .tsv files, one for each dataset in the input
  list object, named \code{'fileName_datasetName.tsv'}
}
}
\description{
Export the list object generated by \code{hpaSubset()} into xlsx format. Due
to the size of some HPA datasets, as well as the limitation of the output
format, exporting the full datasets generated by \code{hpaDownload()} is not
recommended. This is a convenient wrapper for `write.` functions.
}
\examples{
  downloadedData <- hpaDownload(downloadList='histology', version='example')
  geneList <- c('TP53', 'EGFR')
  tissueList <- c('breast', 'cerebellum', 'skin 1')
  cancerList <- c('breast cancer', 'glioma', 'melanoma')

  subsetData <- hpaSubset(data=downloadedData,
                           targetGene=geneList,
                           targetTissue=tissueList,
                           targetCancer=cancerList)
  hpaExport(data=subsetData,
            fileName='TP53_EGFR_in_tissue_cancer.xlsx',
            fileType='xlsx')

}
\seealso{
Other downloadable datasets functions: 
\code{\link{hpaDownload}()},
\code{\link{hpaSubset}()}
}
\concept{downloadable datasets functions}
