% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_clustering.R
\name{run_clustering}
\alias{run_clustering}
\title{Module Detection}
\usage{
run_clustering(
  ppi,
  method = c("FC", "RW", "ML", "clp", "MCL"),
  expan = 2,
  infla = 5,
  iter = 50
)
}
\arguments{
\item{ppi}{A data.frame containing pathogen proteins in the
first column,host proteins in the second column, and edge weight in the
third column.}

\item{method}{Module detection algorithms including:
\itemize{
\item \code{FC} - fast-greedy algorithm.
\item \code{RW} - walktrap algorithm.
\item \code{ML} - multi-level community algorithm.
\item \code{clp} - label propagation algorithm.
\item \code{MCL} - markov clustering.
}}

\item{expan}{Numeric value > 1 for the expansion parameter.
See \code{\link[MCL]{mcl}} for more details.}

\item{infla}{Numeric value > 0 for the inflation power coefficient.
See \code{\link[MCL]{mcl}} for more details.}

\item{iter}{An integer, the maximum number of iterations for the MCL.
See \code{\link[MCL]{mcl}} for more details.}
}
\value{
A data.frame with the enrichment analysis results.
}
\description{
This function contains five module detection algorithms
including fast-greedy algorithm
(\code{FC}), walktrap algorithm (\code{RW}), multi-level community
algorithm
(\code{ML}), label propagation algorithm (\code{clp}), and markov
clustering (\code{MCL}).
}
\details{
run_clustering
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}