% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrowPlot.R
\name{arrowPlot}
\alias{arrowPlot}
\title{PCA before and after arrow plot for harman results}
\usage{
arrowPlot(
  harmanresults,
  pc_x = 1,
  pc_y = 2,
  colBy = "batch",
  palette = "rainbow",
  col,
  length = 0.1,
  legend = TRUE,
  ...
)
}
\arguments{
\item{harmanresults}{an instance of \code{harmanresults}.}

\item{pc_x}{integer, principle component for the plot x dimension.}

\item{pc_y}{integer, principle component for the plot y dimension.}

\item{colBy}{string, colour the points by the experimental or batch
variable; legal values are \code{expt} and \code{batch}. The palette function
specified in \code{palette} is used. This parameter is overridden by
\code{col}.}

\item{palette}{string, the function to call to create a vector of
contiguous colours with the levels of factor in \code{colBy} steps.}

\item{col, }{colour vector for the points. This parameter overrides
\code{palette}.}

\item{length}{length of the \code{\link{arrow}} heads, default is 0.1.}

\item{legend}{logical, whether to display a legend on the plot}

\item{...}{further arguments passed to or from other methods.}
}
\value{
None
}
\description{
Generates an arrow plot for an instance of
\code{\link{harmanresults}}. The tail of the arrow is the starting point
(original) in principle coordinates, while the arrow head is the new point
(corrected) in principle coordinates. It can be observed that on principle
components that have undergone correction
(\code{harmanresults$stats$correction < 1.0}), the samples within a batch
will be coordinately moved towards 0 on that principle component.
}
\details{
Generates a Principle Component plot for an instance of
\code{harmanresults}. If a vector of colours is supplied via the \code{col}
argument, then a legend will not be drawn.
}
\examples{
library(HarmanData)
data(OLF)
expt <- olf.info$Treatment
batch <- olf.info$Batch
olf.harman <- harman(olf.data, expt, batch)
arrowPlot(olf.harman, pc_x=2, pc_y=3, length=0.2)
}
\seealso{
\code{\link{harmanresults}} \code{\link{plot.harmanresults}}
}
