% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaPlot.R
\name{pcaPlot}
\alias{pcaPlot}
\title{PCA plot for harman results}
\usage{
pcaPlot(
  harmanresults,
  pc_x = 1,
  pc_y = 2,
  this = "corrected",
  colBy = "batch",
  pchBy = "expt",
  palette = "rainbow",
  legend = TRUE,
  col,
  pch,
  ...
)
}
\arguments{
\item{harmanresults}{An instance of \code{harmanresults}.}

\item{pc_x}{integer, principle component for the plot x dimension.}

\item{pc_y}{integer, principle component for the plot y dimension.}

\item{this}{string, legal values are \code{original} or \code{corrected}.}

\item{colBy}{string, colour the points by the experimental or batch
variable; legal values
are \code{expt} and \code{batch}. The palette function specified in
\code{palette} is used.
This parameter is overridden by \code{col}.}

\item{pchBy}{string, point-type by the experimental or batch variable;
legal values are \code{expt} and \code{batch}. This parameter is overridden
by \code{pch}.}

\item{palette}{string, the function to call to create a vector of
contiguous colours with the levels of factor in \code{colBy} steps.}

\item{legend}{logical, whether to display a legend on the plot.}

\item{col, }{colour vector for the points. This parameter overrides
\code{colBy} and \code{palette}.}

\item{pch, }{integer vector giving the point type.  This parameter
overrides \code{pchBy}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
None
}
\description{
Generates a Principle Component plot for an instance of
\code{\link{harmanresults}}.
}
\details{
If a vector of colours is supplied via the \code{col} argument,
then a legend will not be drawn.
}
\examples{
library(HarmanData)
data(OLF)
expt <- olf.info$Treatment
batch <- olf.info$Batch
olf.harman <- harman(as.matrix(olf.data), expt, batch)
pcaPlot(olf.harman)
pcaPlot(olf.harman, colBy='expt')
pcaPlot(olf.harman, pc_x=2, pc_y=3, this='original', pch=17)
}
\seealso{
\code{\link{harmanresults}} \code{\link{plot.harmanresults}}
}
