% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annHeatmap.R
\name{doLegend}
\alias{doLegend}
\title{A simple legend}
\usage{
doLegend(breaks, col, side)
}
\arguments{
\item{breaks}{a vector of breaks defining a set of intervals for the data}

\item{col}{a vector of colors corresponding to the intervals.}

\item{side}{integer between 1 and 4, indicating on which side of the main
plot the legend is supposed to be drawn. Standard interpretation: 1 = below,
continuing clock-wise.}
}
\value{
The locations of the ticks returned by the call to
\code{\link{axis}}
}
\description{
Add a simple legend in form of a color bar to a plot.
}
\details{
This is an extremely simple way of giving a visual impression of what
numerical values correspond to a given color. The actual plot is done via a
call to \code{\link{image}} and \code{\link{axis}}.
}
\examples{

    ## Set up data
    doLegend(1:9, g2r.colors(8), 2)

}
\seealso{
\code{\link{plot.annHeatmap}}, \code{\link{niceBreaks}},
\code{\link{g2r.colors}}
}
\keyword{utilities}
