% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annHeatmap.R
\name{plot.annHeatmap}
\alias{plot.annHeatmap}
\title{Plotting method for annotated heatmaps}
\usage{
\method{plot}{annHeatmap}(x, widths, heights, ...)
}
\arguments{
\item{x}{an object of class \code{annHeatmap}}

\item{widths}{a numerical vector giving the widths of the sub-plots
currently defined}

\item{heights}{a numerical vector giving the heights of the sub-plots
currently defined}

\item{\dots}{extra graphical parameters, currently ignored}
}
\value{
\code{x}, invisibly returned. If \code{widths} or \code{heights}
have been specified, they overwrite the corresponding items
\code{x$layout$width} and \code{x$layout$height} in \code{x}.
}
\description{
Plotting method for annotated heatmaps
}
\details{
This function displays an annotated heatmap object that has been previously
generated by \code{annHeatmap2} or on of its wrappers. The arguments
\code{widths} and \code{heights} work as in \code{layout}.
}
\examples{

    ## Define the map
    require(Biobase)
    data(sample.ExpressionSet)
    ex1 = sample.ExpressionSet[51:85,]
    map1 = annHeatmap2(exprs(ex1), ann=list(Col=list(data=pData(ex1))),
                   cluster=list(Col=list(cuth=3000)))
    
    ## Plot it               
    plot(map1)
    
    ## More heatmap, smaller dendrogram/annotation
    map2 = plot(map1, heights = c(1,6,1))
    
    ## Compare layout before/after
    with(map1$layout, layout(plot, width, height))
    layout.show(4)
    with(map2$layout, layout(plot, width, height))
    layout.show(4)

}
\seealso{
\code{\link{annHeatmap2}}, \code{\link{heatmapLayout}},
\code{\link{layout}}
}
\keyword{hplot}
