% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_conda.R
\name{with_CondaEnv}
\alias{with_CondaEnv}
\alias{local_CondaEnv}
\title{Use Conda environments.}
\usage{
with_CondaEnv(
  new,
  code,
  pathToMiniConda = NULL,
  path_action = "prefix",
  pythonpath_action = "replace",
  perl5lib_action = "replace",
  path_additional = NULL,
  pythonpath_additional = NULL,
  perl5lib_additional = NULL
)

local_CondaEnv(
  new = list(),
  pathToMiniConda = NULL,
  path_action = "prefix",
  pythonpath_action = "replace",
  perl5lib_action = "replace",
  path_additional = NULL,
  pythonpath_additional = NULL,
  perl5lib_additional = NULL,
  .local_envir = parent.frame()
)
}
\arguments{
\item{new}{The name of conda environment to include in the temporary R environment.}

\item{code}{Code to execute in the temporary R environment}

\item{pathToMiniConda}{Path to miniconda.}

\item{path_action}{Should new values "replace", "prefix" or "suffix" existing PATH variable.}

\item{pythonpath_action}{Should new values "replace", "prefix" or "suffix" existing PYTHONPATH variable.}

\item{perl5lib_action}{Should new values "replace", "prefix" or "suffix" existing PERL5LIB variable.}

\item{path_additional}{Additional paths to suffix to existing PATH variable.}

\item{pythonpath_additional}{Additional paths to suffix to existing PYTHONPATH variable.}

\item{perl5lib_additional}{Additional paths to suffix to existing PERL5LIB variable.}

\item{.local_envir}{The environment to use for scoping.}
}
\value{
Nothing returned.
}
\description{
Use Conda environments

Use Conda environments
}
\details{
This function will execute the provided code while using a the specific conda environment provided.
For a more detailed walkthrough check our webpage: https://rockefelleruniversity.github.io/Herper_Page/

This function will update the local environment to use a specific conda environment provided.
For a more detailed walkthrough check our webpage: https://rockefelleruniversity.github.io/Herper_Page/
}
\examples{
local_CondaEnv(new = "herper_env")
}
\author{
Thomas Carroll
}
