% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_InteractionSet.R
\name{make_InteractionSet}
\alias{make_InteractionSet}
\title{Convert HiCdiff results to InteractionSet object}
\usage{
make_InteractionSet(hic.table)
}
\arguments{
\item{hic.table}{A hic.table object.}
}
\value{
An object of class InteractionSet
}
\description{
Convert HiCdiff results to InteractionSet object
}
\details{
This function will convert data from HiCdiff results in the
    hic.table object format to the InteractionSet format which makes
    use of GRanges objects.
}
\examples{
# create hic.table
data(HMEC.chr22)
data(NHEK.chr22)
hic.table <- create.hic.table(HMEC.chr22, NHEK.chr22, chr='chr22')
# convert to InteractionSet
gi <- make_InteractionSet(hic.table)
}
