% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_centromere.R
\name{remove_centromere}
\alias{remove_centromere}
\title{Function to remove centromere columns and rows from a full Hi-C
    contact matrix}
\usage{
remove_centromere(mat)
}
\arguments{
\item{mat}{A full Hi-C matrix}
}
\value{
A list of (1) the column/row numbers of the centromere and
    (2) the Hi-c matrix with the centromere removed
}
\description{
Function to remove centromere columns and rows from a full Hi-C
    contact matrix
}
\examples{
m <- matrix(rpois(100, 5), 10, 10)
m[5,] <- 0
m[,5] <- 0
remove_centromere(m)
}
