% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_signature.R
\name{visPMS}
\alias{visPMS}
\title{visualize probabisitic mutaiton signature for the independent model}
\usage{
visPMS(
  vF,
  numBases,
  baseCol = NA,
  trDir = FALSE,
  charSize = 5,
  isScale = FALSE,
  alpha = 2,
  charLimit = 0.25
)
}
\arguments{
\item{vF}{a matrix for mutation signature}

\item{numBases}{the number of flanking bases}

\item{baseCol}{the colour of the bases (A, C, G, T, plus/minus strand)}

\item{trDir}{the index whether the strand direction is plotted or not}

\item{charSize}{the size of the character}

\item{isScale}{the index whether the height of the flanking base is changed
or not}

\item{alpha}{the parameter for the Renyi entropy (applicable only if the
isScale is TRUE)}

\item{charLimit}{the limit of char size}
}
\value{
a plot of the input mutational signature
}
\description{
Generate visualization of mutation signatures for the model with
             substitution patterns and flanking bases represented by the
             indepenent representation.
}
\examples{

load(system.file("extdata/sample.rdata", package="HiLDA"))
Param <- pmgetSignature(G, K = 3)

sig <- slot(Param, "signatureFeatureDistribution")[1,,]
visPMS(sig, numBases = 5, isScale = TRUE)


}
