% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/donors.R
\name{donors}
\alias{donors}
\alias{donors_default_columns}
\alias{donor_detail}
\alias{donor_derived}
\alias{donor_metadata}
\title{HuBMAP Donors}
\usage{
donors()

donors_default_columns(as = c("tibble", "character"))

donor_detail(uuid)

donor_derived(uuid, entity_type = c("Dataset", "Sample"))

donor_metadata(uuid)
}
\arguments{
\item{as}{character(1) return format. One of \code{"tibble"} (default),
or \code{"character"}.}

\item{uuid}{character(1) corresponding to the HuBMAP Donor UUID
string. This is expected to be a 32-digit hex number.}

\item{entity_type}{character(1) selected derived entity type.
One of \code{"Sample"} or \code{"Dataset"} (default).}
}
\value{
\verb{*_columns()} returns a named list \code{name}
containing the column name used in the tibble returned by
\code{samples()}, \code{datasets()},  \code{donors()},
\code{collections()},  or \code{publications()}.
When \code{as = "tibble"},the return value is a tibble
with paths as elements and abbreviations as names.
}
\description{
\code{donors()} returns details about available samples, ordered by
last modified dates

\verb{*_columns()} returns a tibble or named
character vector describing the content of the tibble returned
by \code{samples()}, \code{datasets()},  \code{donors()}, \code{collections()},
or \code{publications()}.

\code{donor_detail()} takes a unique donor_id and
returns details about one specified sample as a tibble

\code{donor_derived()} takes a unique donor_id and
returns the derived dataset or/and sample details.

\code{donor_metadata()} takes a unique donor_id and
returns the metadata of the donor.
}
\details{
Additional details are provided on the HuBMAP consortium
webpage, https://software.docs.hubmapconsortium.org/apis

Additional details are provided on the HuBMAP consortium
webpage, https://software.docs.hubmapconsortium.org/apis

Additional details are provided on the HuBMAP consortium
webpage, https://software.docs.hubmapconsortium.org/apis

Additional details are provided on the HuBMAP consortium
webpage, https://software.docs.hubmapconsortium.org/apis
}
\examples{
donors()
donors_default_columns()

uuid <- "1dcde05aea3509b2cf89a41ceb3d700f"
donor_detail(uuid)
uuid <- "1dcde05aea3509b2cf89a41ceb3d700f"
donor_derived(uuid, "Sample")

uuid <- "d37df2cad4e80dc368763caefccf7140"
donor_metadata(uuid)

}
