% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{GeneScatterPlot}
\alias{GeneScatterPlot}
\alias{GeneScatterPlot.SingleCellExperiment}
\alias{GeneScatterPlot,SingleCellExperiment-method}
\title{Visualize gene expression over nonlinear dimensionality reduction}
\usage{
GeneScatterPlot.SingleCellExperiment(
  object,
  genes,
  return.plot,
  dim.reduction.type,
  point.size,
  title,
  plot.expressing.cells.last,
  nrow,
  ncol
)

\S4method{GeneScatterPlot}{SingleCellExperiment}(
  object,
  genes = "",
  return.plot = FALSE,
  dim.reduction.type = "tsne",
  point.size = 0.7,
  title = "",
  plot.expressing.cells.last = FALSE,
  nrow = NULL,
  ncol = NULL
)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{genes}{a character vector of the genes to be visualized}

\item{return.plot}{whether to return the ggplot2 object or just
draw it (default \code{FALSE})}

\item{dim.reduction.type}{"tsne" or "umap" (default "tsne")}

\item{point.size}{point size (default 0.7)}

\item{title}{text to write above the plot}

\item{plot.expressing.cells.last}{whether to plot the expressing genes
last to make the points more visible}

\item{nrow}{a positive integer that specifies the number of rows in
the plot grid. Default is \code{NULL}.}

\item{ncol}{a positive integer that specifies the number of columns
in the plot grid. Default is \code{NULL}.}
}
\value{
ggplot2 object if return.plot=TRUE
}
\description{
GeneScatterPlot enables visualizing gene expression of a gene over
nonlinear dimensionality reduction with t-SNE or UMAP.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- RunTSNE(sce)
GeneScatterPlot(sce,"CD14",dim.reduction.type="tsne")
sce <- RunUMAP(sce)
GeneScatterPlot(sce,"CD14",dim.reduction.type="umap")

}
\keyword{gene}
\keyword{plot}
\keyword{scatter}
\keyword{visualization}
