% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-functions.R
\name{annotation_issues}
\alias{annotation_issues}
\title{Check for genomic annotation problems in IS matrices.}
\usage{
annotation_issues(matrix)
}
\arguments{
\item{matrix}{Either a single matrix or a list of matrices, ideally obtained
via \code{import_parallel_Vispa2Matrices()} or \code{import_single_Vispa2Matrix()}}
}
\value{
Either \code{NULL} if no issues were detected or 1 or more data frames
with genomic coordinates of the IS and the number of distinct
genes associated
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This helper function checks if each individual integration site,
identified by the \code{mandatory_IS_vars()},
has been annotated with two or more distinct gene symbols.
}
\examples{
data("integration_matrices", package = "ISAnalytics")
annotation_issues(integration_matrices)
}
\seealso{
Other Import functions helpers: 
\code{\link{date_formats}()},
\code{\link{default_af_transform}()},
\code{\link{default_iss_file_prefixes}()},
\code{\link{matching_options}()},
\code{\link{quantification_types}()}
}
\concept{Import functions helpers}
