% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions.R
\name{generate_default_folder_structure}
\alias{generate_default_folder_structure}
\title{Generate a default folder structure, following VISPA2 standards}
\usage{
generate_default_folder_structure(
  type = "correct",
  dir = tempdir(),
  af = "default",
  matrices = "default"
)
}
\arguments{
\item{type}{One value between \code{"correct"}, \code{"incorrect"} and \code{"both"}.
Tells the function wheter to produce a correct structure or introduce some
errors (mainly for testing purposes).}

\item{dir}{Path to the folder in which the structure will be produced}

\item{af}{Either \code{"default"} for the association file provided as example
in the package or a custom association file as a data frame}

\item{matrices}{Either \code{"default"} for integration matrices
provided as example
in the package or a custom multi-quantification matrix}
}
\value{
A named list containing the path to the association file and
the path to the top level folder(s) of the structure
}
\description{
The function produces a folder structure in the file system at the provided
path that respects VISPA2 standards, with package-included data.
}
\section{Required tags}{

The function will explicitly check for the presence of these tags:
\itemize{
\item project_id
\item tag_seq
\item vispa_concatenate
}
}

\examples{
fs_path <- generate_default_folder_structure(type = "correct")
fs_path
}
\seealso{
Other Utilities: 
\code{\link{as_sparse_matrix}()},
\code{\link{comparison_matrix}()},
\code{\link{enable_progress_bars}()},
\code{\link{export_ISA_settings}()},
\code{\link{generate_Vispa2_launch_AF}()},
\code{\link{generate_blank_association_file}()},
\code{\link{import_ISA_settings}()},
\code{\link{separate_quant_matrices}()},
\code{\link{transform_columns}()}
}
\concept{Utilities}
