% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis-functions.R
\name{iss_source}
\alias{iss_source}
\title{Find the source of IS by evaluating sharing.}
\usage{
iss_source(
  reference,
  selection,
  ref_group_key = c("SubjectID", "CellMarker", "Tissue", "TimePoint"),
  selection_group_key = c("SubjectID", "CellMarker", "Tissue", "TimePoint"),
  timepoint_column = "TimePoint",
  by_subject = TRUE,
  subject_column = "SubjectID"
)
}
\arguments{
\item{reference}{A data frame containing one or more groups of reference.
Groups are identified by \code{ref_group_key}}

\item{selection}{A data frame containing one or more groups of interest
to compare.
Groups are identified by \code{selection_group_key}}

\item{ref_group_key}{Character vector of column names that identify a
unique group in the \code{reference} data frame}

\item{selection_group_key}{Character vector of column names that identify a
unique group in the \code{selection} data frame}

\item{timepoint_column}{Name of the column holding time point
info?}

\item{by_subject}{Should calculations be performed for each subject
separately?}

\item{subject_column}{Name of the column holding subjects information.
Relevant only if \code{by_subject = TRUE}}
}
\value{
A list of data frames or a data frame
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
The function computes the sharing between a reference group of interest
for each time point and a selection of groups of interest. In this way
it is possible to observe the percentage of shared integration sites between
reference and each group and identify in which time point a certain IS was
observed for the first time.
}
\examples{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    value_cols = c("seqCount", "fragmentEstimate")
)
df1 <- aggreg |>
    dplyr::filter(.data$Tissue == "BM")
df2 <- aggreg |>
    dplyr::filter(.data$Tissue == "PB")
source <- iss_source(df1, df2)
source
ggplot2::ggplot(source$PT001, ggplot2::aes(
    x = as.factor(g2_TimePoint),
    y = sharing_perc, fill = g1
)) +
    ggplot2::geom_col() +
    ggplot2::labs(
        x = "Time point", y = "Shared IS \% with MNC BM",
        title = "Source of is MNC BM vs MNC PB"
    )
}
\seealso{
Other Analysis functions: 
\code{\link{CIS_grubbs}()},
\code{\link{HSC_population_size_estimate}()},
\code{\link{compute_abundance}()},
\code{\link{cumulative_is}()},
\code{\link{gene_frequency_fisher}()},
\code{\link{is_sharing}()},
\code{\link{sample_statistics}()},
\code{\link{top_integrations}()},
\code{\link{top_targeted_genes}()}
}
\concept{Analysis functions}
