% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-functions.R
\name{sharing_heatmap}
\alias{sharing_heatmap}
\title{Plot IS sharing heatmaps.}
\usage{
sharing_heatmap(
  sharing_df,
  show_on_x = "g1",
  show_on_y = "g2",
  absolute_sharing_col = "shared",
  title_annot = NULL,
  plot_relative_sharing = TRUE,
  rel_sharing_col = c("on_g1", "on_union"),
  show_perc_symbol_rel = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{sharing_df}{The data frame containing the IS sharing data}

\item{show_on_x}{Name of the column to plot on the x axis}

\item{show_on_y}{Name of the column to plot on the y axis}

\item{absolute_sharing_col}{Name of the column that contains the absolute
values of IS sharing}

\item{title_annot}{Additional text to display in the title}

\item{plot_relative_sharing}{Logical. Compute heatmaps also for relative
sharing?}

\item{rel_sharing_col}{Names of the columns to consider as relative sharing.
The function is going to plot one heatmap per column in this argument.}

\item{show_perc_symbol_rel}{Logical. Only relevant if \code{plot_relative_sharing}
is set to TRUE, should the percentage symbol be displayed in relative
heatmaps?}

\item{interactive}{Logical. Requires the package
\href{https://plotly.com/r/getting-started/}{plotly} is required for this
functionality. Returns the heatmaps as interactive HTML widgets.}
}
\value{
A list of plots or widgets
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Displays the IS sharing calculated via \link{is_sharing} as heatmaps.
}
\examples{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    value_cols = c("seqCount", "fragmentEstimate")
)
sharing <- is_sharing(aggreg,
    minimal = FALSE,
    include_self_comp = TRUE
)
sharing_heatmaps <- sharing_heatmap(sharing_df = sharing)
sharing_heatmaps$absolute
sharing_heatmaps$on_g1
sharing_heatmaps$on_union
}
\seealso{
\link{is_sharing}

Other Plotting functions: 
\code{\link{CIS_volcano_plot}()},
\code{\link{HSC_population_plot}()},
\code{\link{circos_genomic_density}()},
\code{\link{fisher_scatterplot}()},
\code{\link{integration_alluvial_plot}()},
\code{\link{sharing_venn}()},
\code{\link{top_abund_tableGrob}()},
\code{\link{top_cis_overtime_heatmap}()}
}
\concept{Plotting functions}
