% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swing.r
\name{swing}
\alias{swing}
\title{Swing statistic}
\usage{
swing(input_data = NULL, pwm_in = NULL, pwm_scores = NULL,
  pseudo_count = 1, p_cut_pwm = 0.05, p_cut_fc = 0.05,
  permutations = 1000, return_network = FALSE, verbose = FALSE)
}
\arguments{
\item{input_data}{A data.frame of phoshopeptide data. Must contain 4 columns
and the following format must be adhered to. Column 1 - Annotation, Column 2
 - centered peptide sequence, Column 3 - Fold Change [-ve to +ve], Column 4 
 - p-value [0-1]. This must be the same dataframe used in scoreSequences()}

\item{pwm_in}{List of PWMs created using buildPWM()}

\item{pwm_scores}{List of PWM-substrate scores created using
scoreSequences()}

\item{pseudo_count}{Pseudo-count acts at two levels. 1) It adds a small
number to the counts to avoid zero divisions, which also 2) avoids log-zero 
transformations. Note that this means that pos, neg and all values in the
output table include the addition of the pseudo-count. Default: "1"}

\item{p_cut_pwm}{Significance level for determining a significant
kinase-substrate enrichment. Default: "0.05"}

\item{p_cut_fc}{Significance level for determining a significant level of
Fold-change in the phosphoproteomics data. Default: "0.05"}

\item{permutations}{Number of permutations to perform. This will shuffle the 
kinase-subtrate edges of the network n times. To not perform permutations and
 only generate the scores, set permutations=1 or permutations=FALSE. Default:
  "1000"}

\item{return_network}{Option to return an interaction network for visualising
in cystoscape. Default = FALSE}

\item{verbose}{Turn verbosity on/off. To turn on, verbose=TRUE. Options are: 
"TRUE, FALSE". Default=FALSE}
}
\value{
A data.table of swing scores
}
\description{
This function integrates the kinase-substrate predictions,
directionality of phosphopeptide fold change and signficance to assess
local connectivity (swing) of kinase-substrate networks. The final score
is a normalised and weighted score of predicted kinase activity. If 
permutations are selected, network node:edges are permutated. P-values will 
be calculated for both ends of the distribution of swing scores (positive and
 negative swing scores).
}
\examples{
## import data
data(example_phosphoproteome)
data(phosphositeplus_human)

## clean up the annotations
## sample 100 data points for demonstration
sample_data <- head(example_phosphoproteome, 100)
annotated_data <- cleanAnnotation(input_data = sample_data)

## build the PWM models:
set.seed(1234)
sample_pwm <- phosphositeplus_human[sample(nrow(phosphositeplus_human), 
1000),]
pwms <- buildPWM(sample_pwm)

## score the PWM - substrate matches
## Using a "random" background, to calculate the p-value of the matches
## Using n = 100 for demonstration
## set.seed for reproducibility
set.seed(1234)
substrate_scores <- scoreSequences(input_data = annotated_data,
                                   pwm_in = pwms,
                                   background = "random",
                                   n = 100)

## Use substrate_scores and annotated_data data to predict kinase activity.
## This will permute the network node and edges 10 times for demonstration.
## set.seed for reproducibility
set.seed(1234)
swing_output <- swing(input_data = annotated_data,
                      pwm_in = pwms,
                      pwm_scores = substrate_scores,
                      permutations = 10)

}
