% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LOLA.R
\name{checkUniverseAppropriateness}
\alias{checkUniverseAppropriateness}
\title{Check universe appropriateness}
\usage{
checkUniverseAppropriateness(userSets, userUniverse, cores = 1, fast = FALSE)
}
\arguments{
\item{userSets}{Regions of interest}

\item{userUniverse}{Regions tested for inclusion in userSets}

\item{cores}{Number of processors}

\item{fast}{Skip the (slow) test for many-to-many relationships}
}
\value{
No return value.
}
\description{
Checks to see if the universe is appropriate for the userSets
Anything in the userSets should be present in the universe.
In addition, 2 different regions in the userSets should not
overlap the same region in the universe
}
\examples{
data("sample_input", package="LOLA") # load userSet
data("sample_universe", package="LOLA") # load userUniverse
checkUniverseAppropriateness(userSets, userUniverse)
}
