% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LOLA.R
\name{redefineUserSets}
\alias{redefineUserSets}
\title{This function will take the user sets, overlap with the universe,
and redefine the user sets as the set of regions in the user
universe that overlap at least one region in user sets. this makes
for a more appropriate statistical enrichment comparison, as the user
sets are actually exactly the same regions found in the universe
otherwise, you can get some weird artifacts from the many-to-many
relationship between user set regions and universe regions.}
\usage{
redefineUserSets(userSets, userUniverse, cores = 1)
}
\arguments{
\item{userSets}{Regions of interest}

\item{userUniverse}{Regions tested for inclusion in userSets}

\item{cores}{Number of processors}
}
\value{
userSets redefined in terms of userUniverse
}
\description{
This function will take the user sets, overlap with the universe,
and redefine the user sets as the set of regions in the user
universe that overlap at least one region in user sets. this makes
for a more appropriate statistical enrichment comparison, as the user
sets are actually exactly the same regions found in the universe
otherwise, you can get some weird artifacts from the many-to-many
relationship between user set regions and universe regions.
}
\examples{
dbPath = system.file("extdata", "hg19", package="LOLA")
regionDB = loadRegionDB(dbLocation=dbPath)
data("sample_universe", package="LOLA")
data("sample_input", package="LOLA")

getRegionSet(regionDB, collections="ucsc_example", filenames="vistaEnhancers.bed")
getRegionSet(dbPath, collections="ucsc_example", filenames="vistaEnhancers.bed")
getRegionFile(dbPath, collections="ucsc_example", filenames="vistaEnhancers.bed")


res = runLOLA(userSets, userUniverse, regionDB, cores=1)
locResult = res[2,]
extractEnrichmentOverlaps(locResult, userSets, regionDB)
writeCombinedEnrichment(locResult, "temp_outfolder")

userSetsRedefined =	redefineUserSets(userSets, userUniverse)
resRedefined = runLOLA(userSetsRedefined, userUniverse, regionDB, cores=1)

g = plotTopLOLAEnrichments(resRedefined)

}
