% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matCorrs.R
\name{matCorrs}
\alias{matCorrs}
\title{A row-wise correlation function calculator}
\usage{
matCorrs(mae)
}
\arguments{
\item{mae}{A MultiAssayExperiment object containing the methylation
and expression data.}
}
\value{
matrix with a correlation value for each gene
}
\description{
\code{matCorrs} Given a MultiAssayExperiment object, the function
computes Pearson and Spearman correlation coefficients
and their significance p-values for every pair of row vectors.
}
\examples{
# Methylation data
methylData <- matrix(runif(50), nrow = 10)
colnames(methylData) <- paste0("samp", 1:ncol(methylData))
rownames(methylData) <- paste0("gene", 1:nrow(methylData))
# Expression data
expresData <- matrix(rnorm(50), nrow = 10)
colnames(expresData) <- paste0("samp", 1:ncol(methylData))
rownames(expresData) <- paste0("gene", 1:nrow(methylData))
# ColData
colDat <- data.frame(
    sampleID = colnames(methylData),
    name = letters[1:ncol(methylData)]
)

rownames(colDat) <- colDat$sampleID
mae <- MultiAssayExperiment::MultiAssayExperiment(
    experiments = list(
        methylation = methylData,
        expression = expresData
    ),
    colData = colDat
)
matCorrs(mae)

}
\keyword{correlation}
