% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeneSel.R
\name{plotGeneSel}
\alias{plotGeneSel}
\title{plotGeneSel}
\usage{
plotGeneSel(
  mae,
  genePos,
  titleText,
  x1 = 1/3,
  x2 = 2/3,
  y1 = NULL,
  y2 = NULL,
  percY1 = 1/3,
  percY2 = 2/3,
  plotGrid = TRUE
)
}
\arguments{
\item{mae}{A MultiAssayExperiment object containing the methylation
and expression data for the specified gene.}

\item{genePos}{The index of the gene to be plotted within the
MultiAssayExperiment object.}

\item{titleText}{plot title.}

\item{x1, x2}{Coordinates of vertical points in the X axis. 
Because it is expected to contain methylation values that vary
between 0 and 1. The default values are 1/3 and 2/3.}

\item{y1, y2}{Coordinates of vertical points in the Y axis. 
Leaving them as NULL assigns them the percentiles of yVec defined by `percY1`
and `percY2`.}

\item{percY1, percY2}{Values used to act as default for `y1`and `y2`
when these are set to `NULL`}

\item{plotGrid}{logical. Defautl to TRUE will plot gridlines over the 
scatterplot.}
}
\value{
a pdf with scatterplots for selected genes
}
\description{
\code{plotGeneSel} plots points on a scatterplot with a 3x3 grid overimposed.
}
\examples{
# Methylation data
methylData <- matrix(runif(50), nrow = 10)
colnames(methylData) <- paste0("samp", 1:ncol(methylData))
rownames(methylData) <- paste0("gene", 1:nrow(methylData))
# Expression data
expresData <- matrix(rnorm(50), nrow = 10)
colnames(expresData) <- paste0("samp", 1:ncol(methylData))
rownames(expresData) <- paste0("gene", 1:nrow(methylData))
# ColData
colDat <- data.frame(
    sampleID = colnames(methylData),
    name = letters[1:ncol(methylData)]
)

rownames(colDat) <- colDat$sampleID
mae <- MultiAssayExperiment::MultiAssayExperiment(
    experiments = list(
        methylation = methylData,
        expression = expresData
    ),
    colData = colDat
)

plotGeneSel(mae, genePos = 7, titleText = "L-shaped gene")

}
\keyword{gene}
\keyword{plot}
\keyword{selection}
