% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap_functions.r
\name{bootstrapSamples_limRots}
\alias{bootstrapSamples_limRots}
\title{Generate Stratified Bootstrap Samples for limRots}
\usage{
bootstrapSamples_limRots(niter, meta.info, group.name)
}
\arguments{
\item{niter}{Integer. The number of bootstrap samples to generate.}

\item{meta.info}{Data frame. Metadata containing sample information,
where each row corresponds to a sample. Factor columns in \code{meta.info}
are used to define strata for sampling.}

\item{group.name}{Character. The name of the column in \code{meta.info} that
defines the grouping variable for the samples.}
}
\value{
A matrix of dimension \code{niter} x \code{n}, where \code{n} is the
number of samples. Each row corresponds to a bootstrap sample, and each
entry is a resampled row name from the metadata, stratified by group and
additional factors.
}
\description{
This function generates stratified bootstrap samples based on the groupings
and additional factors in the metadata. The function ensures that samples
are drawn proportionally based on strata defined by the interaction of
factor columns in the metadata.
}
\details{
The function works by first identifying the factors in the \code{meta.info} data
frame that are used to create strata for sampling. Within each group defined
by \code{group.name}, the function samples according to the strata proportions,
ensuring that samples are drawn from the correct groups and strata in a
proportional manner.
}
