% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap_functions.r
\name{bootstrapS}
\alias{bootstrapS}
\title{Generate Bootstrap Samples}
\usage{
bootstrapS(niter, meta.info, group.name)
}
\arguments{
\item{niter}{Integer. The number of bootstrap samples to generate.}

\item{meta.info}{Data frame. Metadata containing sample information, where
each row corresponds to a sample.}

\item{group.name}{Character. The name of the column in \code{meta.info} that
defines the grouping variable for the samples.}
}
\value{
A matrix of dimension \code{niter} x \code{n}, where \code{n} is the
number of samples. Each row corresponds to a bootstrap sample, and each
entry is a resampled row name from the metadata.
}
\description{
This function generates bootstrap samples from the input metadata. It samples
with replacement within each group defined in the metadata.
}
\details{
The function works by resampling the row names of the metadata for each group
separately.
}
