% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calOverlaps.R
\name{calOverlaps}
\alias{calOverlaps}
\title{Compute overlaps between bootstrap and permuted features.}
\usage{
calOverlaps(D, S, pD, pS, nrow, N, N_len, ssq, niter, mat_obs, mat_perm)
}
\arguments{
\item{D}{Numeric matrix of observed statistics/features.}

\item{S}{Numeric matrix of observed standard errors or relevant values.}

\item{pD}{Numeric matrix of permuted statistics/features.}

\item{pS}{Numeric matrix of permuted standard errors or relevant values.}

\item{nrow}{Integer, number of features per resample block.}

\item{N}{Integer vector of "top list sizes" for overlap.}

\item{N_len}{Integer, length of N.}

\item{ssq}{Numeric, regularization constant.}

\item{niter}{Numeric, total number of bootstrap/permutation rounds.}

\item{mat_obs}{Matrix (niter x length(N)) to be filled
with overlaps(observed).}

\item{mat_perm}{Matrix (niter x length(N)) to be filled with
overlaps (permuted).}
}
\value{
List with mat_obs=overlaps (observed) and
mat_perm=overlaps (permuted).
}
\description{
Compute overlaps between bootstrap and permuted features.
}
