% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_methQTL.R
\name{doMethQTLChromosome}
\alias{doMethQTLChromosome}
\title{doMethQTLChromosome}
\usage{
doMethQTLChromosome(
  meth.qtl,
  chrom,
  sel.covariates = NULL,
  p.val.cutoff = 1e-05,
  out.dir = NULL,
  ncores = 1
)
}
\arguments{
\item{meth.qtl}{An Object of type \code{\link{MethQTLInput-class}}.}

\item{chrom}{Character vector represeting the chromosome to be investigated.}

\item{sel.covariates}{Covariates as column names of the sample annotation sheet stored in \code{meth.qtl} to be
used for covariate adjustment.}

\item{p.val.cutoff}{The p-value used for methQTL calling}

\item{out.dir}{Optional argument specifying the output directory}

\item{ncores}{The number of cores to be used}
}
\value{
A data frame with seven columns:
       \describe{
           \item{CpGs}{The CpG ID chosen to be the representative CpG in the methQTL}
           \item{SNP}{The SNP ID (as rsNNNNNN) involved in the methQTL}
           \item{Beta}{The coefficient estimate of the linear model}
           \item{P.value}{The p-value associated with the coefficient estimate}
           \item{Chromosome}{The chromosome name}
           \item{Position.CpG}{The genomic position of the CpG}
           \item{Position.SNP}{The genomic position of the SNP}
           \item{Distance}{The distance between the CpG and the SNP}
       }
}
\description{
This functions computes the methQTL interactions for a single chromosome
}
\examples{
meth.qtl <- loadMethQTLInput(system.file("extdata","reduced_methQTL",package="MAGAR"))
meth.qtl.res <- doMethQTLChromosome(meth.qtl,chrom="chr18",p.val.cutoff=0.01)
}
\seealso{
doMethQTL
}
\author{
Michael Scherer
}
