% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovFromBoots.R
\name{CovFromBoots}
\alias{CovFromBoots}
\title{Extract the inter-gene covariance matrices for continuous and discrete components of a MAST model for a given coefficient from bootstrap replicates}
\usage{
CovFromBoots(boots = NULL, coefficient = NULL)
}
\arguments{
\item{boots}{a multidimensional array returned by `bootVcov1` or `pbootVcov1`.}

\item{coefficient}{`character` the name of the model coefficient for which to return the inter-gene covariance matrices.}
}
\value{
list with components "C" and "D" containing covariance matrices for the continuous and discrete components of the model.
}
\description{
Computes the genewise covariance for a model coefficient from bootstrap replicates
from `MAST::bootVcov1()`. If coefficients are unestimable (i.e. NA) for a gene, that row/column in the
covariance matrix will be NA. Returns a list with components "C" and "D" containing the covariance
matrices for the "C"ontinuous and "D"iscrete components of the MAST model.
}
