% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_helper.R
\name{mbecTestModel}
\alias{mbecTestModel}
\title{Check If Model Is Estimable}
\usage{
mbecTestModel(input.obj, model.vars = NULL, model.form = NULL)
}
\arguments{
\item{input.obj}{MbecData, phyloseq or list (counts, meta-data).}

\item{model.vars}{Names of covariates to construct formula from.}

\item{model.form}{Formula for a linear model to test.}
}
\value{
Either NULL if everything is fine or a vector of strings that denote
covariates and their respective problematic levels.
}
\description{
Applies Limma's 'nonEstimable()' to a given model and returns NULL if
everything works out, or a warning and a vector of problematic covariates in
case there is a problem.
}
\details{
The usefull part is that you can just put in all the covariates of interest
as model.vars and the function will build a simple linear model and its
model.matrix for testing. You can also provide more complex linear models
and the function will do the rest.
}
\examples{
# This will return NULL because it is estimable.
data(dummy.mbec)
eval.obj <- mbecTestModel(input.obj=dummy.mbec,
model.vars=c("group","batch"))
}
\keyword{Wrapper}
\keyword{limma}
\keyword{nonEstimable}
