% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbqnSimuDistortion.R
\name{mbqnSimuDistortion}
\alias{mbqnSimuDistortion}
\title{Perturbation of sample mean and scale}
\usage{
mbqnSimuDistortion(x, s.mean = 0.05, s.scale = 0.01)
}
\arguments{
\item{x}{a matrix or data frame.}

\item{s.mean}{scatter of relative change of mean.}

\item{s.scale}{scatter of realtive change in scale, i.e. 0.01
corresponds to 1 percent.}
}
\value{
List with:
\item{\code{x.mod}}{perturbed matrix}
\item{\code{mx.offset}}{numeric array of shifts of the sample means}
\item{\code{mx.scale}}{numeric array of relative scales of the sample
standard deviations.}
}
\description{
\code{mbqnSimuDistortion} adds a random perturbation of mean and
scale to each column of a matrix.
}
\details{
Shift and scale the sample mean and standard deviation of a matrix.
The perturbation of center and scale relative to mean and standard deviation
of each sample are drawn from a Gaussian distribution \eqn{|N(0,\sigma^2)|}
with \eqn{\sigma_mean=}\code{s.mean} and
\eqn{\sigma_scale}=\code{s.scale}, respectively.
}
\examples{
set.seed(1234)
x <- mbqnSimuData("omics.dep")
df <- mbqnSimuDistortion(x)
}
\references{
Brombacher, E., Schad, A., Kreutz, C. (2020). Tail-Robust
Quantile Normalization. BioRxiv.
}
\seealso{
\code{\link[=mbqnSimuData]{mbqnSimuData()}} for data generation.
}
\author{
Ariane Schad
}
