% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVEval.R
\name{CVEval}
\alias{CVEval}
\alias{CVEval}
\title{Method for the calculation of a correlation vector}
\usage{
CVEval(gem.part, gem.all, seed, splits)
}
\arguments{
\item{gem.part}{Part of gene expression matrix only containing gene set of interest with genes as rows and samples as columns}

\item{gem.all}{All of gene expression matrix}

\item{seed}{Seed of highly correlating samples}

\item{splits}{Number of cuts from hierarchical clustering}
}
\value{
Correlation vector
}
\description{
Upon identifying a bicluster seed with \code{FindSeed}, one of the next
steps is to identify which genes not in your chosen gene set are also
highly correlated to the bicluster found. This is done by \code{CVEval},
and the output is known as the correlation vector.
}
\details{
\code{CVeval} uses hierarchical clustering to select the genes most 
representative of the bicluster and then uses the average expression of
these genes across the sample seed and calculates the correlation of
every gene measured across the sample seed to this average expression value.

The correlation vector is the output of this calculation.
}
\examples{
data(CCLE_small)
data(Mitochondrial_genes)

mito.loc <- (row.names(CCLE_small) \%in\% Mitochondrial_genes)
CCLE.mito <- CCLE_small[mito.loc,]

set.seed(102)
CCLE.seed <- FindSeed(gem = CCLE.mito,
                      seed.size = 10,
                      iterations = 100,
                      messages = 1000)

CCLE.sort <- SampleSort(gem = CCLE.mito,seed = CCLE.seed,sort.length = 11)

# Full ordering are in Vignette_sort in sysdata.rda
CCLE.samp.sort <- MCbiclust:::Vignette_sort[[1]]

CCLE.pc1 <- PC1VecFun(top.gem = CCLE.mito,
                      seed.sort = CCLE.samp.sort,
                      n = 10)

CCLE.cor.vec <-  CVEval(gem.part = CCLE.mito,
                            gem.all = CCLE_small,
                            seed = CCLE.seed,
                            splits = 10)

CCLE.bic <- ThresholdBic(cor.vec = CCLE.cor.vec,sort.order = CCLE.samp.sort,
                         pc1 = as.numeric(CCLE.pc1))

CCLE.pc1 <- PC1Align(gem = CCLE_small, pc1 = CCLE.pc1,
                     cor.vec = CCLE.cor.vec ,
                     sort.order = CCLE.samp.sort,
                     bic =CCLE.bic)

CCLE.fork <- ForkClassifier(CCLE.pc1, samp.num = length(CCLE.bic[[2]]))

}
