% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorScoreCalc.r
\name{CorScoreCalc}
\alias{CorScoreCalc}
\title{Calculate correlation score}
\usage{
CorScoreCalc(gene.expr.matrix, sample.vec)
}
\arguments{
\item{gene.expr.matrix}{Gene expression matrix with genes as rows and samples as columns}

\item{sample.vec}{Vector of samples}
}
\value{
The correlation score
}
\description{
The standard method to calculate the correlation score used to judge biclusters
in MCbiclust
}
\examples{
data(CCLE_small)
data(Mitochondrial_genes)

mito.loc <- which(row.names(CCLE_small) \%in\% Mitochondrial_genes)
CCLE.mito <- CCLE_small[mito.loc,]

random.seed <- sample(seq(length = dim(CCLE.mito)[2]),10)
CCLE.seed <- FindSeed(gem = CCLE.mito,
                      seed.size = 10,
                      iterations = 100,
                      messages = 100)


CorScoreCalc(CCLE.mito, random.seed)
CorScoreCalc(CCLE.mito, CCLE.seed)

CCLE.hicor.genes <- as.numeric(HclustGenesHiCor(CCLE.mito,
                                                CCLE.seed,
                                                cuts = 8))

CorScoreCalc(CCLE.mito[CCLE.hicor.genes,], CCLE.seed)
}
